<?php
  ob_start();
  session_start();
  
  include 'WebClientPrint.php';
  use Neodynamic\SDK\Web\WebClientPrint;
  
  //Add WCPP Detection Metatag for supporting IE
  $head = WebClientPrint::getWcppDetectionMetaTag();
  
  $title = 'Detecting WebClientPrint Processor...';
  
?>

<div class="container">
    <div id="msgInProgress">
        <div class="row">
            <div class="span9">
                <div id="mySpinner" style="width:32px;height:32px"></div>
                <br />
                Detecting WCPP utility at client side...
                <br />
                <br />
            </div>
        </div>
    </div>
    <div id="msgInstallWCPP" style="display:none;">    
        <div class="row">
            <div class="span9">
                <h3>#1 Install WebClientPrint Processor (WCPP) 2.0!</h3>
                <p>
                    <strong>WCPP is a native app (without any dependencies!)</strong> that handles all print jobs 
                    generated by the <strong>WebClientPrint for PHP component</strong> at the server side. The WCPP 
                    is in charge of the whole printing process and can be 
                    installed on <strong>Windows, Linux &amp; Mac!</strong>
                </p>
                <p>
                    <a class="btn btn-success" href="http://www.neodynamic.com/downloads/wcpp/" target="_blank">Download and Install WCPP from Neodynamic website</a><br />                
                </p>
                <h3>#2 After installing WCPP...</h3>
                <p>
                    <a href="home.php">You can go and test WebClientPrint for PHP</a>
                </p>
            </div>
        </div>
    </div>
    
    
</div> 

<?php
  $content = ob_get_contents();
  ob_clean();
?>


<script type="text/javascript">
    
        var wcppPingDelay_ms = 5000; 

        function wcppDetectOnSuccess(){
            var wcppVer = arguments[0];
            if(wcppVer.substring(0, 1) == "2")
                window.location.href = "home.php";
            else
                wcppDetectOnFailure();
        }

        function wcppDetectOnFailure() {
            $("#msgInProgress").hide();
            $("#msgInstallWCPP").show();                
        }

        $(function () {
            var spinner = new Spinner({
	          lines: 12, 
	          length: 7, 
	          width: 3, 
	          radius: 10, 
	          color: "#336699", 
	          speed: 1, 
	          trail: 60               
              }).spin($("#mySpinner")[0]); 
        });
</script>

<script src="http://fgnass.github.io/spin.js/spin.min.js" type="text/javascript"></script>

<?php
  // Create WCPP detection script
  echo WebClientPrint::createWcppDetectionScript();
?>

<?php
  $script = ob_get_contents();
  ob_clean();
  
  include("template.php");
?>